<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type");

include 'db_config.php';

$data = json_decode(file_get_contents("php://input"), true);

if (!isset($data['username'], $data['email'], $data['password'], $data['birthdate'])) {
    echo json_encode(["success" => false, "message" => "Data tidak lengkap"]);
    exit;
}

$username = $data['username'];
$email = $data['email'];
$password = $data['password'];
$birthdate = $data['birthdate'];

$hashed_password = password_hash($password, PASSWORD_DEFAULT);
$otp = rand(100000, 999999);

// Tambahkan waktu sekarang untuk created_at dan otp_created_at
$created_at = date("Y-m-d H:i:s");
$otp_created_at = date("Y-m-d H:i:s");

// Perbarui query untuk menyertakan created_at dan otp_created_at
$sql = "INSERT INTO users (username, email, password, birthdate, otp, created_at, otp_created_at) VALUES (?, ?, ?, ?, ?, ?, ?)";
$stmt = $conn->prepare($sql);
$stmt->bind_param("sssssss", $username, $email, $hashed_password, $birthdate, $otp, $created_at, $otp_created_at);

if ($stmt->execute()) {
    echo json_encode(["success" => true, "message" => "Registrasi berhasil"]);
} else {
    echo json_encode(["success" => false, "message" => "Gagal registrasi: " . $conn->error]);
}

$stmt->close();
$conn->close();
?>
