<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

include 'db_config.php';

$data = json_decode(file_get_contents("php://input"), true);

$email = $data['email'] ?? null;
$password = $data['password'] ?? null;

// Validasi data
if (empty($email) || empty($password)) {
    echo json_encode(["success" => false, "message" => "Email dan password harus diisi."]);
    exit;
}

// Cek kecocokan email dan password
$query = "SELECT * FROM users WHERE email = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $email);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows == 1) {
    $user = $result->fetch_assoc();
    if (password_verify($password, $user['password'])) {
        echo json_encode(["success" => true, "message" => "Login berhasil."]);
    } else {
        echo json_encode(["success" => false, "message" => "Password salah."]);
    }
} else {
    echo json_encode(["success" => false, "message" => "Email tidak ditemukan."]);
}

$stmt->close();
$conn->close();
?>
