<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");
header("Access-Control-Max-Age: 3600");
header("Access-Control-Allow-Headers: Content-Type, Access-Control-Allow-Headers, Authorization, X-Requested-With");

$servername = "localhost";
$username = "root";
$password = "";
$dbname = "x_app";

// Membuat koneksi
$conn = new mysqli($servername, $username, $password, $dbname);

// Memeriksa koneksi
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Mendapatkan data dari input
$data = json_decode(file_get_contents('php://input'), true);

// Memeriksa apakah data berhasil di-decode
if (is_null($data)) {
    echo json_encode(array("message" => "Error: Invalid JSON input"));
    exit;
}

// Menginisialisasi variabel dengan nilai default
$username = isset($data['username']) ? $data['username'] : null;
$handle = isset($data['handle']) ? $data['handle'] : null;
$content = isset($data['content']) ? $data['content'] : null;
$imagePath = isset($data['imagePath']) ? $data['imagePath'] : null;
$profileImage = isset($data['profileImage']) ? $data['profileImage'] : null;

// Memastikan semua data yang diperlukan ada
if (empty($username) || empty($handle) || empty($content)) {
    echo json_encode(array("message" => "Error: Missing required fields"));
    exit;
}

// Menyiapkan dan mengeksekusi pernyataan SQL
$sql = "INSERT INTO posts (username, handle, content, imagePath, profileImage) VALUES (?, ?, ?, ?, ?)";
$stmt = $conn->prepare($sql);
$stmt->bind_param("sssss", $username, $handle, $content, $imagePath, $profileImage);

if ($stmt->execute()) {
    echo json_encode(array("message" => "Post added successfully"));
} else {
    echo json_encode(array("message" => "Error: " . $stmt->error));
}

$stmt->close();
$conn->close();
?>